# -*- coding: utf-8 -*-
r"""Augment the current pkg-plist with entries for byte-compiled files.

The result is written to stdout.

Usage: augment_plist.py INPUT

Python

"""

from __future__ import print_function, absolute_import

import io
import os
import re
import sys


def main():

    infile = sys.argv[1]
    outlines = []

    for line_orig in io.open(infile, encoding="us-ascii"):
        outlines.append(line_orig)
        line = line_orig.rstrip()
        if not line:
            continue
        #
        # NOTE: Sync with the "compileall" installation step in the Makefile
        #
        if re.search("/tests?/|tools/make_ssl_data.py", line):
            continue

        if line.endswith(".py"):
            for compiled_suffix in ('c', 'o'):
                outlines.append(
                    "%%BYTECOMPILE%%{line}{compiled_suffix}\n"
                    .format(line=line, compiled_suffix=compiled_suffix))
    for line in outlines:
        sys.stdout.write(line)


if __name__ == "__main__":
    main()
