--- lib-python/2.7/sysconfig.py.orig	2022-03-28 09:50:42 UTC
+++ lib-python/2.7/sysconfig.py
@@ -366,13 +366,15 @@ def _generate_posix_vars():
         module.build_time_vars = vars
         sys.modules[name] = module
 
+    pypy_wrkdir = os.environ.get("PYPY_WRKDIR")  # this is set by FreeBSD port
+
     pybuilddir = 'build/lib.%s-%s' % (get_platform(), sys.version[:3])
+    if pypy_wrkdir is not None:
+        pybuilddir = os.path.join(pypy_wrkdir, pybuilddir)
     if hasattr(sys, "gettotalrefcount"):
         pybuilddir += '-pydebug'
-    try:
+    if not os.path.isdir(pybuilddir):
         os.makedirs(pybuilddir)
-    except OSError:
-        pass
     destfile = os.path.join(pybuilddir, name + '.py')
 
     with open(destfile, 'wb') as f:
@@ -382,7 +384,10 @@ def _generate_posix_vars():
         pprint.pprint(vars, stream=f)
 
     # Create file used for sys.path fixup -- see Modules/getpath.c
-    with open('pybuilddir.txt', 'w') as f:
+    pybuilddir_txt = 'pybuilddir.txt'
+    if pypy_wrkdir is not None:
+        pybuilddir_txt = os.path.join(pypy_wrkdir, pybuilddir_txt)
+    with open(pybuilddir_txt, 'w') as f:
         f.write(pybuilddir)
 
 def _init_posix(vars):
