# NOTE: Also includes bsd.pypy.mk and (indirectly) bsd.port.pre.mk

PKGNAMEPREFIX=	${PYTHON_PKGNAMEPREFIX}
DISTFILES=

BUILD_DEPENDS+=	${PYTHON_IMPL}:lang/${PYTHON_IMPL}
RUN_DEPENDS+=	${PYTHON_IMPL}:lang/${PYTHON_IMPL}

CFFI_MODULE?=	_${PORTNAME}

FLAVORS=	pypy pypy3
FLAVOR?=	${FLAVORS:[1]}

PYTHON_IMPL=	${FLAVOR}
PYTHON_PORTVERSION=	${DISTVERSION}
PYTHON_PKGNAMEPREFIX=	${PYTHON_IMPL}-
PYTHON_CMD=	${LOCALBASE}/bin/${PYTHON_IMPL}

.include "${.CURDIR}/../../lang/pypy/bsd.pypy.mk"

#
# Check that this port's build selected option FORPYIMPL39 or FORPYIMPL310
# is compatible to the corresponding build option of the installed pypy3.
#
.if ${FLAVOR} == pypy3 && exists(${LOCALBASE}/bin/pypy3)
_PYPY_SC_PLATSTDLIB=	${:!${LOCALBASE}/bin/pypy3 -c 'import sysconfig; print(sysconfig.get_path("platstdlib"))'!}
.  if ${_PYPY_SC_PLATSTDLIB:T} != ${PYTHON_IMPL_MINOR}
IGNORE=		Port option mismatch: must match FORPYIMPLxx of the installed lang/pypy3
.  endif
.endif

.if ${FLAVOR} == pypy
PLIST_FILES=	${PYPY_DIR}/lib_pypy/${CFFI_MODULE}_cffi.${PYPY_CFFI_VER}.so
.else  # pypy3
PLIST_FILES=	${PYPY_DIR}/lib/${PYTHON_IMPL_MINOR}/${CFFI_MODULE}_cffi.${PYPY_CFFI_VER}.so
.endif

do-build:
.if ${FLAVOR} == pypy
	${CP} ${LOCALBASE}/${PYPY_DIR}/lib_pypy/${CFFI_MODULE}_build.py ${WRKDIR}/${PORTNAME}.py
.else     # newer pypy3
	${CP} ${LOCALBASE}/${PYPY_DIR}/lib/${PYTHON_IMPL_MINOR}/${CFFI_MODULE}_build.py ${WRKDIR}/${PORTNAME}.py
.endif
	(cd ${WRKDIR}; \
		${PYTHON_CMD} -c "from ${PORTNAME} import ${CFFI_NAME} as ffi; ffi.compile('${WRKDIR}');")

do-install:
.if ${FLAVOR} == pypy
	${MKDIR} ${STAGEDIR}${PREFIX}/${PYPY_DIR}/lib_pypy/`dirname ${CFFI_MODULE}`/
	${INSTALL_LIB} ${WRKDIR}/${CFFI_MODULE}_cffi.${PYPY_CFFI_VER}.so ${STAGEDIR}${PREFIX}/${PYPY_DIR}/lib_pypy/`dirname ${CFFI_MODULE}`/
.else  # newer pypy3
	${MKDIR} ${STAGEDIR}${PREFIX}/${PYPY_DIR}/lib/${PYTHON_IMPL_MINOR}/`dirname ${CFFI_MODULE}`/
	${INSTALL_LIB} ${WRKDIR}/${CFFI_MODULE}_cffi.${PYPY_CFFI_VER}.so ${STAGEDIR}${PREFIX}/${PYPY_DIR}/lib/${PYTHON_IMPL_MINOR}/`dirname ${CFFI_MODULE}`/
.endif
