--- lib-python/3/sysconfig.py.orig	2022-03-28 09:53:47 UTC
+++ lib-python/3/sysconfig.py
@@ -436,7 +436,11 @@ def _generate_posix_vars(args):
         pprint.pprint(vars, stream=f)
 
     # Create file used for sys.path fixup -- see Modules/getpath.c
-    with open('pybuilddir.txt', 'w', encoding='ascii') as f:
+    pybuilddir_txt = 'pybuilddir.txt'
+    pypy_wrkdir = os.environ.get("PYPY_WRKDIR")  # this is set by FreeBSD port
+    if pypy_wrkdir is not None:
+        pybuilddir_txt = os.path.join(pypy_wrkdir, pybuilddir_txt)
+    with open(pybuilddir_txt, 'w', encoding='utf8') as f:
         f.write(pybuilddir)
 
 def _init_posix(vars):
