--- rpython/translator/platform/posix.py.orig	2025-02-24 17:28:26 UTC
+++ rpython/translator/platform/posix.py
@@ -32,6 +32,18 @@ class BasePosix(Platform):
 
     def _includedirs(self, include_dirs):
         assert '' not in include_dirs
+        #
+        # fag: While libexpat is now vendored in PyPy3, when compiling
+        # on FreeBSD "/usr/local/include" comes several times before
+        # the include path to the vendored "expat.h". So: remove all
+        # such items but the last one.
+        # Also assert that the last one is also the last entry in
+        # "include_dirs".
+        #
+        while include_dirs.count('/usr/local/include') > 1:
+            incpos = include_dirs.index('/usr/local/include')
+            del include_dirs[incpos]
+        assert include_dirs[-1] == '/usr/local/include'
         return ['-I%s' % idir for idir in include_dirs]
 
     def _linkfiles(self, link_files):
