# -*- mode: makefile -*-
# NOTE: Also includes bsd.port.pre.mk

PKGNAMEPREFIX=	${FLAVOR}-
DISTFILES=

.if !defined(LICENSE)
LICENSE=	MIT PSFL
LICENSE_COMB=	multi
.endif

PYPY_DEFAULT_DISTVERSION?=	7.3.19

BUILD_DEPENDS+=	${FLAVOR}==${PYPY_PORTVERSION}:lang/${FLAVOR}
RUN_DEPENDS+=	${FLAVOR}>=${PYPY_PORTVERSION}:lang/${FLAVOR}

CFFI_MODULE?=	_${PORTNAME}

FLAVORS=	pypy2
FLAVOR=		${FLAVORS:[1]}

PYPY_PYTHON_IMPL=	pypy2.7
PYPY_PORTVERSION=	${DISTVERSION}
PYPY_CMD=	${LOCALBASE}/bin/${PYPY_PYTHON_IMPL}

PYPY_DIR=	pypy-${DISTVERSION:C|([0-9]+)\.([0-9]+).*|\1.\2|}
PYPY_CFFI_VER=	pypy-73

PLIST_FILES+=	${PYPY_DIR}/lib_pypy/${CFFI_MODULE}_cffi.${PYPY_CFFI_VER}.so

FFI_MODULE_NAME?=	_ffi

.include <bsd.port.pre.mk>

do-build:
	${CP} ${LOCALBASE}/${PYPY_DIR}/lib_pypy/${CFFI_MODULE}_build.py ${WRKDIR}/${PORTNAME}.py
	(cd ${WRKDIR}; \
		${PYPY_CMD} -c "from ${PORTNAME} import ${FFI_MODULE_NAME} as ffi; ffi.compile('${WRKDIR}');")

do-install:
	${MKDIR} ${STAGEDIR}${PREFIX}/${PYPY_DIR}/lib_pypy/`dirname ${CFFI_MODULE}`/
	${INSTALL_LIB} ${WRKDIR}/${CFFI_MODULE}_cffi.${PYPY_CFFI_VER}.so ${STAGEDIR}${PREFIX}/${PYPY_DIR}/lib_pypy/`dirname ${CFFI_MODULE}`/
