--- rpython/rlib/rposix.py.orig	2022-12-29 08:05:46 UTC
+++ rpython/rlib/rposix.py
@@ -3014,6 +3014,30 @@ if sys.platform.startswith('linux'):
         res = c_sendfile(out_fd, in_fd, lltype.nullptr(_OFF_PTR_T.TO), count)
         return handle_posix_error('sendfile', res)
 
+elif sys.platform.startswith('freebsd'):    
+    # FreeBSD
+    #
+    # Please note that the implementation below is partial;
+    # the VOIDP is an iovec for sending headers and trailers which
+    # CPython uses for the headers and trailers argument, and it also
+    # has a flags argument. None of these are currently supported.
+    sendfile_eci = ExternalCompilationInfo(includes=["sys/socket.h"])
+    _OFF_PTR_T = rffi.CArrayPtr(OFF_T)
+    # NB: the VOIDP is an struct sf_hdtr for sending headers and trailers
+    c_sendfile = rffi.llexternal('sendfile',
+            [rffi.INT, rffi.INT, OFF_T, rffi.SIZE_T, rffi.VOIDP, _OFF_PTR_T, rffi.INT],
+            rffi.INT, save_err=rffi.RFFI_SAVE_ERRNO,
+            compilation_info=sendfile_eci)
+
+    def sendfile(out_fd, in_fd, offset, count):
+        with lltype.scoped_alloc(_OFF_PTR_T.TO, 1) as sbytes:
+            sbytes[0] = 0  # rffi.cast(OFF_T, count)
+            res = c_sendfile(in_fd, out_fd, offset, count, lltype.nullptr(rffi.VOIDP.TO), sbytes, 0)
+            if res != 0:
+                return handle_posix_error('sendfile', res)
+            res = sbytes[0]
+        return res    
+
 elif not _WIN32:
     # Neither on Windows nor on Linux, so probably a BSD derivative of
     # some sort. Please note that the implementation below is partial;
